/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.OnItemHurt;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.contexts.base.Priority;
import com.mlib.effects.SoundHandler;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class GoldFuelledEnchantment
extends CustomEnchantment {
    public GoldFuelledEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(Registries.GOLDEN).slots(EquipmentSlots.ALL).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    @AutoInstance
    public static class Handler {
        final Supplier<GoldFuelledEnchantment> enchantment = Registries.GOLD_FUELLED;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("GoldFuelled").comment("Completely repairs gold tools and armour for one gold ingot when the item is about to be destroyed.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnItemHurt.listen(this::restoreItem).priority(Priority.LOWEST).addCondition(Condition.isServer()).addCondition(Condition.predicate(data -> data.player != null)).addCondition(Condition.predicate(data -> this.enchantment.get().hasEnchantment(data.itemStack))).addCondition(Condition.predicate(OnItemHurt.Data::isAboutToBroke)).insertTo(group);
        }

        private void restoreItem(OnItemHurt.Data data) {
            assert (data.player != null);
            if (this.consumeGoldIngot(data.player)) {
                Vec3 position = data.player.m_20182_();
                SoundHandler.ITEM_BREAK.play(data.getLevel(), position);
                data.extraDamage = -data.itemStack.m_41776_();
            }
        }

        private boolean consumeGoldIngot(ServerPlayer player) {
            for (Slot slot : player.f_36095_.f_38839_) {
                ItemStack itemStack = slot.m_7993_();
                if (itemStack.m_41720_() != Items.f_42417_) continue;
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                return true;
            }
            return false;
        }
    }
}

